/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datagen.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GasToGasRecipeBuilder
extends MekanismRecipeBuilder<GasToGasRecipeBuilder> {
    private final ChemicalStackIngredient.GasStackIngredient input;
    private final GasStack output;

    protected GasToGasRecipeBuilder(ChemicalStackIngredient.GasStackIngredient input, GasStack output, ResourceLocation serializerName) {
        super(serializerName);
        this.input = input;
        this.output = output;
    }

    public static GasToGasRecipeBuilder activating(ChemicalStackIngredient.GasStackIngredient input, GasStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This solar neutron activator recipe requires a non empty gas output.");
        }
        return new GasToGasRecipeBuilder(input, output, GasToGasRecipeBuilder.mekSerializer("activating"));
    }

    public static GasToGasRecipeBuilder centrifuging(ChemicalStackIngredient.GasStackIngredient input, GasStack output) {
        if (output.isEmpty()) {
            throw new IllegalArgumentException("This Isotopic Centrifuge recipe requires a non empty gas output.");
        }
        return new GasToGasRecipeBuilder(input, output, GasToGasRecipeBuilder.mekSerializer("centrifuging"));
    }

    @Override
    protected GasToGasRecipeResult getResult(ResourceLocation id) {
        return new GasToGasRecipeResult(id);
    }

    public class GasToGasRecipeResult
    extends MekanismRecipeBuilder.RecipeResult {
        protected GasToGasRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void m_7917_(@Nonnull JsonObject json) {
            json.add("input", GasToGasRecipeBuilder.this.input.serialize());
            json.add("output", (JsonElement)SerializerHelper.serializeGasStack(GasToGasRecipeBuilder.this.output));
        }
    }
}

